<!DOCTYPE html>
<?php
require_once('../Db/dbconfig.php');
@$name=$_GET['username'];
@$userid=$_GET['userid'];
?>
<html>
<head>
<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/css/bootstrap.min.css" integrity="sha384-Gn5384xqQ1aoWXA+058RXPxPg6fy4IWvTNh0E263XmFcJlSAwiGgFAW/dAiS6JXm" crossorigin="anonymous">
<link rel="stylesheet" href="https://cdn.datatables.net/1.10.4/css/jquery.dataTables.min.css">
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
<script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/js/bootstrap.min.js" integrity="sha384-JZR6Spejh4U02d8jOt6vLEHfe/JQGiRRSQQxSfFWpi1MquVdAyjUar5+76PVCmYl" crossorigin="anonymous"></script>
<script src="https://cdn.datatables.net/1.10.4/js/jquery.dataTables.min.js"></script>
<script src="https://kit.fontawesome.com/c17eae44a3.js" crossorigin="anonymous"></script>
<style type="text/css">
@media only screen and (max-height: 700px) {
	.child{
	  width:1000px;
	  float:left;
	  font-size:15px;
	  font-family:arial;
	  padding:10px;
	  cursor: pointer;
	}
}
</style>
</head>
<body>
<div class="card">
	<div class="page-header">
      <h3 class="page-title"  >
        <span class="page-title-icon bg-gradient-primary text-white mr-2">
        <i class="fas fa-cart-arrow-down fa-xs" style="color: black"></i>
        </span><b>Purchase View</b></h3>
	</div>
	<div class="card-body child" style="overflow: auto;">
		<table id="datatableid" class="table table-striped table-bordered table-hover">
			<thead class="thead-dark">
				<tr style="background-color:#091a09">
					<th class="center">
						
					</th>
					<th>Sr. No</th>
					<th>Invoice No</th>
					<th>Challan No</th>
					<th>Supplier Name</th>
					<th>Product Name</th>
					<th>Quantity</th>	
					<th>Type</th>
					<th>Date</th>
					<th>View</th>
					
					<th>Edit</th>
					<th>Delete</th>
				
				</tr>
			</thead>
			<tbody>
			<?php 
				$sql = "select pur.p_id, pur.inv_no, pur.cha_no, pur.vno, p.item as item_category, p2.description as item,s.name as supplier_name, qt.q_name as quantity_type,qt.id as qtytypeid, pur.quantity, pur.created_at from 
purchase pur,product p,productitem p2,supplier s,quantity_type qt where 
pur.item_category = p.id and pur.item = p2.id and pur.supplier_name = s.id and pur.quantity_type = qt.id and pur.status = 1;";
				$result = $con->query($sql);

				if ($result->num_rows > 0) 
				{
				    // output data of each row
		    		while($row = $result->fetch_assoc()) 
		    		{
			?>
			<tr style="background-color:#AFF3CA">
				<td class="center">
					
					<p style="display: none"><?php echo $row['p_id']?></p>
				</td>
				<td>
					<p><?php echo $row['p_id']?></p>
				</td>
				<td>
					<p><?php echo $row['inv_no']?></p>
				</td>
				<td>
					<p><?php echo $row['cha_no']?></p>
				</td>

				<td>
					<p><?php echo $row['supplier_name']?></p>
				</td>
				<td>
					<p><?php echo $row['item']?></p>
				</td>
				<td>
					<p><?php 

					if($row['qtytypeid'] == '1' or $row['qtytypeid'] == '3'){
						if($row['quantity'] != 0){
							echo ($row['quantity']/1000);
						}else{
							echo $row['quantity'];
						}
					}else{
						echo $row['quantity'];
					}
					?>
					</p>
				</td>
				<td>
					<p><?php echo $row['quantity_type']?></p>
				</td>
				<td>
					<p><?php 
					$date = new DateTime($row['created_at'], new DateTimeZone('MST'));
					$date->setTimezone(new DateTimeZone('Asia/Kolkata'));
					echo $date->format('Y-m-d H:i:s');
					?></p>
				</td>
				<td>
						<a href="#"><button type="button" name="view" class="btn btn-primary" onclick="openViewModal('<?php echo $row['p_id']?>')">View</button></a>
				</td> 
				
				<td>
						<a href="../view/purchase_edit.php?id=<?php echo $row['p_id']?>&userid=<?php echo @$userid; ?>"><button type="button" name="edit" class="btn btn-primary">Edit</button></a>
				</td>
				<td>
					<button type="button" class="btn btn-primary deletebtn" title="Delete"><i class="ace-icon fa fa-trash-o"></i></button>
				</td>
				
			</tr>
			<?php
					}
				}

			?>
			</tbody>
		</table>
	</div>
</div>

<!--Purchase View Modal-->
<div id="show_purch" class="modal fade" role="dialog" tabindex="-1" aria-hidden="true"> 
  <div class="modal-dialog">
    <!-- Modal content-->
    <div class="modal-content">
      <div class="modal-header">
        <h4 class="modal-title">Purchase View</h4>
		<button type="button" class="close" data-dismiss="modal">&times;</button>
        
      </div>
      <div class="modal-body">
       
		<form method="POST">
		
		<div class=row>
			<div class="form-group col-6">
	            <label>Challen Number</label>
	            <input type="text" class="form-control" id="cha_no" readonly>
	        </div>
	        <div class="form-group col-6">
	            <label>Vendors Code</label>
	            <input type="text" class="form-control" id="l_no" readonly>
        	</div>
        	<div class="form-group col-6">
	            <label>Invoice Number</label>
	            <input type="text" class="form-control" id="inv" readonly>
        	</div>
        	<div class="form-group col-6">
	            <label>Date</label>
	            <input type="text" class="form-control" id="dat" readonly>
        	</div>
        	<div class="form-group col-6">
	            <label>Time</label>
	            <input type="text" class="form-control" id="time" readonly>
        	</div>
        	<div class="form-group col-6">
	            <label>Vehicle Number</label>
	            <input type="text" class="form-control" id="vno" readonly>
        	</div>
        	<div class="form-group col-6">
	            <label>Item Category</label>
	            <input type="text" class="form-control" id="item_cat" readonly>
        	</div>
        	<div class="form-group col-6">
	            <label>Item Description</label>
	            <input type="text" class="form-control" id="itemDesp" readonly>
        	</div>
        	<div class="form-group col-6">
	            <label>Supplier Name</label>
	            <input type="text" class="form-control" id="suppnm" readonly>
        	</div>
        	<div class="form-group col-6">
	            <label>Product Type</label>
	            <input type="text" class="form-control" id="ptype" readonly>
        	</div>
        	<div class="form-group col-6">
	            <label>Quantity</label>
	            <input type="text" class="form-control" id="quantity" readonly>
        	</div>
        	<div class="form-group col-6">
	            <label>Quantity Type</label>
	            <input type="text" class="form-control" id="qty_type" readonly>
        	</div>
        	<div class="form-group col-6">
	            <label>Lab report</label>
	            <input type="text" class="form-control" id="lab_report" readonly>
        	</div>
        	<div class="form-group col-6">
	            <label>Lab report File upload</label>
	            <input type="text" class="form-control" id="lap_report_file" readonly>
	            <img id="preview" height="100" width="100" src='<?php echo $row['lap_report_file']; ?>'> 
        	</div>
        </div>
		<button type="button" style="background:radial-gradient(#FFF176, #ff3300)" class="btn btn-default" data-dismiss="modal">Close</button>
		</form> 

      </div>
      <div class="modal-footer">
       
      </div>
    </div>

  </div>
</div>
</body>

<script type="text/javascript">
$(document).ready(function(){
	var userid = '<?php echo @$userid; ?>';

	var table = $('#datatableid').DataTable( {
		rowReorder: true,
		"order": [[ 8, "desc" ]],
        columnDefs: [
            { orderable: true, targets: '_all' }
            
        ]
    } );

	$('#datatableid').on('click','.deletebtn',function() {
      
      $tr = $(this).closest('tr');

      var data = $tr.children('td').map(function(){
        return $(this).text();
      }).get();

      var pid = data[0].trim();
      if (confirm("Product will be deleted from Storage too! Are You Sure?")) {
      	 $.ajax({
            url: '../controller/purchase_controller.php',
            method: 'POST',
            data:'type=deleteFromPurchase&puchaseId='+pid+'&userId='+userid,
            
            success: function(msg) {
              console.log('deleteFromPurchase',msg);
              if(msg.status == true){
                alert('Product Deleted Successfully');
                location.reload();
              }else{
                alert(msg.msg);
              }
            },

            error: function (request, status, error) {
              console.log("request : ", request);
              console.log("status  : ", status);
              console.log("error   : ", error);
              alert('Unable to delete Product');
            }             
        });
      	
      
      //$('#weight').val(data[5].trim());
	}
    });
	
});

function openViewModal(pid){
	console.log('id',pid);
	$.ajax( {
    url: '../controller/purchase_controller.php',
    type: 'POST',
    data: 'id='+pid+'&type=viewPurchase',

    success: function(data){
    	console.log('MsgData',data);
	    if(data.status == true){
	      $('#cha_no').val(data.data[0].cha_no);
	      $('#l_no').val(data.data[0].l_no);
	      $('#inv').val(data.data[0].inv_no);
	      $('#dat').val(data.data[0].dat);
	      $('#time').val(data.data[0].time);
	      $('#vno').val(data.data[0].vno);
	      $('#item_cat').val(data.data[0].item_category);
	      $('#itemDesp').val(data.data[0].item);
	      $('#suppnm').val(data.data[0].supplier_name);
	      $('#ptype').val(data.data[0].ptype);
	      if(data.data[0].qtytypeid == '1' || data.data[0].qtytypeid == '3'){
			if(data.data[0].quantity != 0){
				$('#quantity').val(data.data[0].quantity/1000);
			}else{
				 $('#quantity').val(data.data[0].quantity);
			}
		  }else{
				 $('#quantity').val(data.data[0].quantity);
		  }
	      $('#qty_type').val(data.data[0].quantity_type);
	      $('#lab_report').val(data.data[0].lab_report);
	      if(data.data[0].lap_report_file != 'upload/'){
		      $('#lap_report_file').val(data.data[0].lap_report_file);
		      $("#preview").attr("src","../controller/"+data.data[0].lap_report_file);
		      document.getElementById('preview').style.display='block';
	  	  }else{
	  	  	  $('#lap_report_file').val('No File Uploaded');
	  	  	  document.getElementById('preview').style.display='none';
	  	  }
	  	}
      
    },
    error: function(r) {
      console.log(r);
      
    }
   });
	$('#show_purch').modal('show');
}
</script>

</html>