<!DOCTYPE html>
<?php
require_once('../Db/dbconfig.php');
@$name=$_GET['username'];
?>
<html>
<head>
<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/css/bootstrap.min.css" integrity="sha384-Gn5384xqQ1aoWXA+058RXPxPg6fy4IWvTNh0E263XmFcJlSAwiGgFAW/dAiS6JXm" crossorigin="anonymous">
<link rel="stylesheet" href="https://cdn.datatables.net/1.10.4/css/jquery.dataTables.min.css">
<script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.12.9/umd/popper.min.js"></script>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
<script src="https://cdn.datatables.net/1.10.4/js/jquery.dataTables.min.js"></script>
<script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/js/bootstrap.min.js" integrity="sha384-JZR6Spejh4U02d8jOt6vLEHfe/JQGiRRSQQxSfFWpi1MquVdAyjUar5+76PVCmYl" crossorigin="anonymous"></script>
<script src="https://kit.fontawesome.com/c17eae44a3.js" crossorigin="anonymous"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.1/css/bootstrap-select.min.css">
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.1/js/bootstrap-select.min.js"></script>
<style type="text/css">
@media only screen and (max-height: 700px) {
	.child{
	  width:1000px;
	  float:left;
	  font-size:15px;
	  font-family:arial;
	  padding:10px;
	  cursor: pointer;
	}
}
select.rou{
 border: 1px solid #ccc;
  -moz-border-radius: 10px;
-webkit-border-radius: 10px;
border-radius: 10px;

-moz-box-shadow: 2px 2px 3px #666;
-webkit-box-shadow: 2px 2px 3px #666;
box-shadow: 2px 2px 3px #666;
font-size: 18px;
padding: 4px 7px;
outline: 0;
-webkit-appearance: none;
}
#round{
 border: 1px solid #ccc;
 -moz-border-radius: 10px;
 -webkit-border-radius: 10px;
 border-radius: 10px;
	
 -moz-box-shadow: 2px 2px 3px #666;
 -webkit-box-shadow: 2px 2px 3px #666;
 box-shadow: 2px 2px 3px #666;
 font-size: 15px;
 padding: 4px 7px;
 outline: 0;
 -webkit-appearance: none;
}
</style>
</head>
<body>
<div class="card">
	<div class="page-header">
      <h3 class="page-title"  >
        <span class="page-title-icon bg-gradient-primary text-white mr-2">
        <i class="fas fa-user-tie fa-xs" style="color: black"></i>
        </span><b>Purchaser Master</b></h3>
	</div>
	<div class=" card-header d-flex flex-row-reverse">
		<button type="button" class="btn btn-primary" id="showModal"><i class="fas fa-plus"></i></button>
        <label class="p-2" style="width:150px;" for="dat"><b>Add Purchaser :</b></label>
	</div>
	<div class="card-body child" style="overflow: auto;">
		<table id="datatableid" class="table table-striped table-bordered table-hover">
			<thead class="thead-dark">
				<tr style="background-color:#660066">
					<th>SrNo.</th>
					<th>Name</th>
					<th>Phone</th>
					<th>Email</th>	
					<th>Address</th>
					<th>Created On</th>
					<?php
					if(@$name == 'superadmin'){
					?>
					<th>Edit</th>
					<th>Delete</th>
					<?php
					}
					?>
				</tr>
			</thead>
			<tbody>
				<?php 
				$sql = "SELECT * FROM purchaser_master";
				$result = $con->query($sql);

				if ($result->num_rows > 0) 
				{
				    // output data of each row
		    		while($row = $result->fetch_assoc()) 
		    		{
			?>
			<tr style="background-color:#AFF3CA">
				<td>
					<p><?php echo $row['id']?></p>
				</td>
				<td>
					<p><?php echo $row['name']?></p>
				</td>
				<td>
					<p><?php echo $row['phone']?></p>
				</td>
				<td>
					<p><?php echo $row['email'];?></p>
				</td>
				<td>
					<p><?php echo $row['address']?></p>
				</td>
				<td>
					<p><?php echo $row['created_by']?></p>
				</td>
				<?php
					if(@$name == 'superadmin'){
				?>
				<td>
					<button type="button" class="btn btn-primary editbtn" title="Edit"><i class="ace-icon fa fa-edit"></i></button>
				</td>
				<td>
					<button type="button" class="btn btn-primary deletebtn" title="Delete"><i class="ace-icon fa fa-trash-o"></i></button>
				</td>
				<?php
					}
				?>
				
			</tr>
			<?php
					}
				}

			?>
			</tbody>
		</table>
	</div>
</div>

<!-- Add Purchaser Modal -->
<div id="add_sup" class="modal fade" role="dialog" tabindex="-1" aria-hidden="true"> 
  <div class="modal-dialog">
    <!-- Modal content-->
    <div class="modal-content">
      <div class="modal-header">
         <h4 class="modal-title">Add Purchaser</h4>
		 <button type="button" class="close" onclick="clearForm('user_form1')" data-dismiss="modal">&times;</button>
       
      </div>
      <div class="modal-body">
       
		<form id="user_form1">
			<div class="form-group">
               <label for="sname">Purchaser Name</label>
                       
               <input type="text" class="form-control" name="sname" id="sname" required>
                      
            </div>
            <div class="form-group">
                <label for="phone">Phone</label>
                <input type="text" class="form-control" maxlength="10" name="phone" id="phone"  oninput="this.value = this.value.replace(/[^0-9.]/g, '').replace(/(\..*)\./g, '$1');" required>
            </div>
            <div class="form-group">
                <label for="email">Email address</label>
                <input type="email" class="form-control" name="email" id="email" placeholder="Email" pattern="[^@\s]+@[^@\s]+\.[^@\s]+" title="Invalid email address" required>
            </div>
			<div class="form-group">
                <label for="address">Address</label>
                <textarea class="form-control" id="address" rows="4" name="address" required></textarea>
            </div>
         
		  <input type="submit" name="add" id="add" style="background-color:#FF6666" class="btn btn-default" value="Submit"/>
		   <button type="button" class="btn btn-default" data-dismiss="modal" onclick="clearForm('user_form1')">Close</button>
		</form> 

      </div>
      <div class="modal-footer">
       
      </div>
    </div>

  </div>
</div>

<!-- Update Purchaser Modal -->
<div id="editModal" class="modal fade" role="dialog" tabindex="-1" aria-hidden="true"> 
  <div class="modal-dialog">
    <!-- Modal content-->
    <div class="modal-content">
      <div class="modal-header">
         <h4 class="modal-title">Edit Purchaser</h4>
		 <button type="button" class="close" onclick="clearForm('user_form2')" data-dismiss="modal">&times;</button>
       
      </div>
      <div class="modal-body">
       
		<form id="user_form2">
			<div class="form-group">
               <label for="sname">Purchaser Name</label>
                       
               <input type="text" class="form-control" name="edsname" id="edsname" disabled>
               <input type="hidden" name="sid" id="sid">
                      
            </div>
            <div class="form-group">
                <label for="phone">Phone</label>
                <input type="text" class="form-control" maxlength="10" name="edphone" id="edphone"  oninput="this.value = this.value.replace(/[^0-9.]/g, '').replace(/(\..*)\./g, '$1');" required>
            </div>
            <div class="form-group">
                <label for="email">Email address</label>
                <input type="email" class="form-control" name="edemail" id="edemail" placeholder="Email Id" pattern="[^@\s]+@[^@\s]+\.[^@\s]+" title="Invalid email address" required>
            </div>
			<div class="form-group">
                <label for="address">Address</label>
                <textarea class="form-control" id="edaddress" rows="4" name="edaddress" required></textarea>
            </div>
         
		  <input type="submit" name="editpur" id="editpur" style="background-color:#FF6666" class="btn btn-default" value="Submit"/>
		   <button type="button" class="btn btn-default" data-dismiss="modal" onclick="clearForm('user_form2')">Close</button>
		</form> 

      </div>
      <div class="modal-footer">
       
      </div>
    </div>

  </div>
</div>
</body>

<script type="text/javascript">
	var table;
	$(document).ready(function(){
		/*document.getElementById("dat").valueAsDate = new Date();*/
		
		table = $('#datatableid').DataTable( {
			rowReorder: true,
			"order": [[ 5, "desc" ]],
	        columnDefs: [
	            { orderable: true, targets: '_all' }
	            
	        ]
	    } );

	$('#showModal').on('click',function() {
			
		$('#add_sup').modal('show');
	});

	$('#datatableid').on('click','.editbtn',function() {
			
		$('#editModal').modal('show');

		$tr = $(this).closest('tr');

		var data = $tr.children('td').map(function(){
			return $(this).text();
		}).get();

		$('#sid').val(data[0].trim());
		$('#edsname').val(data[1].trim());
		$('#edphone').val(data[2].trim());
		$('#edemail').val(data[3].trim());
		$('#edaddress').val(data[4].trim());
				
	});


	$('#datatableid').on('click','.deletebtn',function() {
		$tr = $(this).closest('tr');

		var datatb = $tr.children('td').map(function(){
			return $(this).text();
		}).get();

		var sId = datatb[0].trim();
		if (confirm("Are You Sure?")) {
			$.ajax( {
	        url: '../controller/purchase_controller.php',
	        method: 'POST',
	        data:'type=deletePurchaser&sid='+sId,
	        
	        success: function(data2){
	          console.log('Msg',data2);
	          if(data2.status == true){
	          	alert(data2.msg); 
	          	window.location.reload();
	      	  }else{
	      	  	alert(data2.msg); 
	      	  }
	        },
	        error: function(r) {
	          alert('Unable To Delete Purchaser'); 
	        }
	      } );
		
		}
	});

	$("#user_form1").submit(function(e) {
	document.getElementById("add").disabled=true;
    //prevent Default functionality
    e.preventDefault();
    //do your own request an handle the results
   	var formData = new FormData(this);

	formData.append('type','addPurchaser');
	
	$.ajax( {
        url:'../controller/purchase_controller.php',
        type: 'POST',
        data: formData,
        processData: false,
        contentType: false,

        success: function(data){
          console.log('Msg',data);
          if(data.status == true){
	        alert('Purchaser Added successfully'); 
	        window.location.reload();
      	  }else{
      	  	alert(data.msg); 
      	  	document.getElementById("add").disabled=false;
      	  }
        },
        error: function(r) {
          alert('Unable to Add Purchaser'); 
          document.getElementById("add").disabled=false;
        }
      } );

	});

	$("#user_form2").submit(function(e) {
	document.getElementById("editpur").disabled=true;
    //prevent Default functionality
    e.preventDefault();
    //do your own request an handle the results
   	var formData = new FormData(this);

	formData.append('type','editPurchaser');
	
	$.ajax( {
        url:'../controller/purchase_controller.php',
        type: 'POST',
        data: formData,
        processData: false,
        contentType: false,

        success: function(data){
          console.log('Msg',data);
          if(data.status == true){
	        alert('Purchaser Updated successfully'); 
	        window.location.reload();
      	  }else{
      	  	alert(data.msg); 
      	  	document.getElementById("editpur").disabled=false;
      	  }
        },
        error: function(r) {
          alert('Unable to Update Purchaser'); 
          document.getElementById("editpur").disabled=false;
        }
      } );

	});
		
});

function clearForm(formname){
	$("#"+formname).trigger("reset");
}

</script>
</html>