<!DOCTYPE html>
<?php
require_once('../Db/dbconfig.php');
?>
<html>
<head>
<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/css/bootstrap.min.css" integrity="sha384-Gn5384xqQ1aoWXA+058RXPxPg6fy4IWvTNh0E263XmFcJlSAwiGgFAW/dAiS6JXm" crossorigin="anonymous">
<link rel="stylesheet" href="https://cdn.datatables.net/1.10.4/css/jquery.dataTables.min.css">
<script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.12.9/umd/popper.min.js"></script>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
<script src="https://cdn.datatables.net/1.10.4/js/jquery.dataTables.min.js"></script>
<script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/js/bootstrap.min.js" integrity="sha384-JZR6Spejh4U02d8jOt6vLEHfe/JQGiRRSQQxSfFWpi1MquVdAyjUar5+76PVCmYl" crossorigin="anonymous"></script>
<script src="https://kit.fontawesome.com/c17eae44a3.js" crossorigin="anonymous"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.1/css/bootstrap-select.min.css">
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.1/js/bootstrap-select.min.js"></script>
<style type="text/css">
@media only screen and (max-height: 700px) {
	.child{
	  width:1000px;
	  float:left;
	  font-size:15px;
	  font-family:arial;
	  padding:10px;
	  cursor: pointer;
	}
}
select.rou{
 border: 1px solid #ccc;
  -moz-border-radius: 10px;
-webkit-border-radius: 10px;
border-radius: 10px;

-moz-box-shadow: 2px 2px 3px #666;
-webkit-box-shadow: 2px 2px 3px #666;
box-shadow: 2px 2px 3px #666;
font-size: 18px;
padding: 4px 7px;
outline: 0;
-webkit-appearance: none;
}
#round{
 border: 1px solid #ccc;
 -moz-border-radius: 10px;
 -webkit-border-radius: 10px;
 border-radius: 10px;
	
 -moz-box-shadow: 2px 2px 3px #666;
 -webkit-box-shadow: 2px 2px 3px #666;
 box-shadow: 2px 2px 3px #666;
 font-size: 15px;
 padding: 4px 7px;
 outline: 0;
 -webkit-appearance: none;
}
</style>
</head>
<body>
<div class="card">
	<div class="page-header">
      <h3 class="page-title"  >
        <span class="page-title-icon bg-gradient-primary text-white mr-2">
        <i class="fas fa-history fa-xs" style="color: black"></i>
        </span><b>Single Materials</b></h3>
	</div>
	<div class=" card-header d-flex flex-row-reverse" style="background: linear-gradient(to right, #003366 0%, #6699ff 100%);">
		<input class="p-2 rounded" style="width:155px;height: 47px" type="date" id="dat" name="dat" value="<?php echo date('Y-m-d'); ?>" onchange="onchangePrdList()">
        <label class="p-2" style="width:60px;" for="dat"><b>Date :</b></label>
		<select data-live-search="true" class="selectpicker p-2 rou" id="prdList" onchange="onchangePrdList()">
		   <?php 
				$sql1="select p3.item as ptypename,tpq.id, p2.description as item from purchase p,total_purchase_qty tpq,
						productitem p2,productype p3 where
						p.item = tpq.item and p.quantity_type = tpq.quantity_type and p.ptype = tpq.ptype and tpq.item = p2.id and tpq.ptype = p3.id
						group by tpq.item,tpq.quantity_type,tpq.ptype order by p.created_at desc;";
				 $res=mysqli_query($con,$sql1);
				while($row1 = mysqli_fetch_array($res))
				{
		        	
			?>
			<option data-subtext="<?php echo $row1['ptypename']; ?>" data-tokens="<?php echo strtolower($row1['item']); ?>" value="<?php echo $row1['id']; ?>"><?php echo $row1['item']; ?></option> 
			<?php
	        	
				}
			?>
		</select>
		<label for="prdList" class="form-label p-2"><b>Product :</b></label>
	</div>
	<div class="card-body child" style="overflow: auto;">
		<table id="datatableid" class="table table-striped table-bordered table-hover">
			<thead class="thead-dark">
				<tr style="background-color:#003366">
					<th>Mode</th>
					<th>Date</th>
					<th>Department</th>
					<th>Quantity</th>	
					<th>Type</th>
					<th>User</th>
				</tr>
			</thead>
			<tbody>
			</tbody>
		</table>
		<select id="userlist" hidden>
		   <?php 
				$sql1="select * from user";
				 $res=mysqli_query($con,$sql1);
				while($row1 = mysqli_fetch_array($res))
				{
		        	
			?>
			<option value="<?php echo $row1['user_id']; ?>"><?php echo $row1['user_name']; ?></option> 
			<?php
	        	
				}
			?>
		</select>
	</div>
</div>
</body>

<script type="text/javascript">
	var table;
	$(document).ready(function(){
		/*document.getElementById("dat").valueAsDate = new Date();*/
		
		table = $('#datatableid').DataTable( {
			rowReorder: true,
			"order": [[ 1, "desc" ]],
	        columnDefs: [
	            { orderable: true, targets: '_all' }
	            
	        ]
	    } );

		getHistory($('#prdList').val(),$('#dat').val());

		
	});

function getHistory(prId,filtDt){
	 $.ajax({
        url: '../controller/purchase_history_controller.php',
        method: 'POST',
        data:'type=getHistoryByStorage&storageId='+prId+'&filterdt='+filtDt,
        
        success: function(msg) {
          console.log('getHistoryByStorage',msg);
          console.log("getHistoryByStorage typeof msg : ", typeof msg);
          if(msg.status == true){
          	table.clear().draw();
            $.each(msg.dataAry, function (i, item) {
	        	var usnm = "";
	        	if(item.user != null){
	        		$('#userlist').val(item.user);
	        		usnm = $('#userlist option:selected').text();
	        	}

	        	var totalqt = parseFloat(item.qty);
	        	if(item.qtytypeId == 1 || item.qtytypeId == 3){
					totalqt = totalqt/1000;
				}
	        	table.row.add([item.mode,item.date,item.dpt,totalqt,item.qtyType,usnm]).draw();
	        });
	      }else{
          	table.clear().draw();
          }
        },

        error: function (request, status, error) {
          console.log("request : ", request);
          console.log("status  : ", status);
          console.log("error   : ", error);
        }             
    });
}

function onchangePrdList(){
	getHistory($('#prdList').val(),$('#dat').val(),table);
}
</script>
</html>